% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_type}
\alias{node_type}
\title{Node type}
\usage{
node_type(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A single string.
}
\description{
\code{node_type()} returns the "type" of the current node as a string.

This is a very useful function for making decisions about how to handle
the current node.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Top level program node
node_type(node)

# The whole `<-` binary operator node
node <- node_child(node, 1)
node
node_type(node)

# Just the literal `<-` operator itself
node <- node_child_by_field_name(node, "operator")
node
node_type(node)
\dontshow{\}) # examplesIf}
}
