% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{add_missing_element_columns}
\alias{add_missing_element_columns}
\title{Add Missing Isotope Columns to mfd}
\usage{
add_missing_element_columns(mfd, missing_cols = "15n")
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{missing_cols}{A character vector of isotope column names that should be checked and added if missing. By default, it includes \code{"15n"}, but additional isotopes can be specified as needed (e.g., \code{"na"}, \code{"d"}, \code{"35cl"}, etc.).}
}
\value{
A \code{data.table} object with the missing isotope columns added,
where missing columns are populated with a default value of \code{0}.
The original \code{mfd} object is modified in place.
}
\description{
This function ensures that missing isotope columns are added to the input data table (\code{mfd}), which is required for further data evaluation that considers isotope information. If any of the specified isotope columns are not already present in the data, they will be added with a default value of \code{0}.

The function is typically used to standardize the dataset by ensuring that all expected isotopes (e.g., nitrogen-15, carbon-13) are represented, even if they are not initially present in the data. The function works by checking for the existence of each specified isotope column and adding the missing ones.
}
\examples{
# Add missing isotope columns to a demo dataset
mfd_with_isotopes <- add_missing_element_columns(mfd = mf_data_demo)

# Add a specific isotope column for Nitrogen-15 (if missing)
mfd_with_15n <- add_missing_element_columns(mfd = mf_data_demo, missing_cols = c("15n", "na"))
}
\seealso{
Other tools: 
\code{\link{order_columns}()}
}
\concept{tools}
