% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vardchangstrs.R
\name{vardchangstrs}
\alias{vardchangstrs}
\title{Variance estimation for measures of annual net change or annual for single stratified sampling designs}
\usage{
vardchangstrs(
  Y,
  H,
  PSU,
  w_final,
  Dom = NULL,
  periods = NULL,
  dataset,
  periods1,
  periods2,
  in_sample,
  in_frame,
  confidence = 0.95,
  percentratio = 1,
  correction = FALSE
)
}
\arguments{
\item{Y}{Variables of interest. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{H}{The unit stratum variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{PSU}{Primary sampling unit variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{w_final}{Weight variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{Dom}{Optional variables used to define population domains. If supplied, variables are calculated for each domain. An object convertible to \code{data.table} or variable names as character vector, column numbers.}

\item{periods}{Variable for the all survey periods. The values for each period are computed independently. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{dataset}{Optional survey data object convertible to \code{data.table}.}

\item{periods1}{The vector of periods from variable \code{periods} describes the first period for measures of change.}

\item{periods2}{The vector of periods from variable \code{periods} describes the second period for measures of change.}

\item{in_sample}{Sample variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{in_frame}{Frame variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{confidence}{optional; either a positive value for confidence interval. This variable by default is 0.95.}

\item{percentratio}{Positive numeric value. All linearized variables are multiplied with \code{percentratio} value, by default - 1.}

\item{correction}{Logical value. If TRUE calculate variance without covariance (negative variance correction).}
}
\value{
A list with objects are returned by the function:
 \itemize{
    \item \code{crossectional_results} - a \code{data.table} containing: \cr
      \code{year} -  survey years, \cr
      \code{subperiods} -  survey sub-periods, \cr
      \code{variable} - names of variables of interest, \cr
      \code{Dom} - optional variable of the population domains, \cr
      \code{estim} - the estimated value, \cr
      \code{var} - the estimated variance of cross-sectional and longitudinal measures, \cr
      \code{sd_w} - the estimated weighted variance of simple random sample, \cr
      \code{se} - the estimated standard error of cross-sectional or longitudinal, \cr
      \code{rse} - the estimated relative standard error (coefficient of variation), \cr
      \code{cv} - the estimated relative standard error (coefficient of variation) in percentage, \cr
      \code{absolute_margin_of_error} - the estimated absolute margin of error, \cr
      \code{relative_margin_of_error} - the estimated relative margin of error, \cr
      \code{CI_lower} - the estimated confidence interval lower bound, \cr
      \code{CI_upper} - the estimated confidence interval upper bound, \cr 
      \code{confidence_level} - the positive value for confidence interval.
   \item \code{annual_results} - a \code{data.table} containing:
      \code{year_1} -  survey years of \code{years1} for measures of annual net change, \cr
      \code{year_2} -  survey years of \code{years2} for measures of annual net change, \cr
      \code{Dom} - optional variable of the population domains, \cr
      \code{variable} - names of variables of interest, \cr
      \code{estim_2} - the estimated value for period2 for measures of annual net change, \cr
      \code{estim_1} - the estimated value for period1 for measures of annual net change, \cr
      \code{estim} - the estimated value, \cr
      \code{var} - the estimated variance, \cr
      \code{se} - the estimated standard error, \cr
      \code{rse} - the estimated relative standard error (coefficient of variation), \cr
      \code{cv} - the estimated relative standard error (coefficient of variation) in percentage, \cr
      \code{absolute_margin_of_error} - the estimated absolute margin of error for period1 for measures of annual, \cr
      \code{relative_margin_of_error} - the estimated relative margin of error in percentage for measures of annual, \cr
      \code{CI_lower} - the estimated confidence interval lower bound, \cr
      \code{CI_upper} - the estimated confidence interval upper bound, \cr
      \code{confidence_level} - the positive value for confidence interval, \cr 
      \code{significant} - is the the difference significant.
  \item\code{annual_results_correction} - a \code{data.table} of corrected variables (if correction TRUE) containing:
   \code{year_1} -  survey years of \code{years1} for measures of annual net change, \cr
      \code{year_2} -  survey years of \code{years2} for measures of annual net change, \cr
      \code{Dom} - optional variable of the population domains, \cr
      \code{variable} - names of variables of interest, \cr
      \code{estim_2} - the estimated value for period2 for measures of annual net change, \cr
      \code{estim_1} - the estimated value for period1 for measures of annual net change, \cr
      \code{estim} - the estimated value, \cr
      \code{var} - the estimated variance, \cr
      \code{se} - the estimated standard error, \cr
      \code{rse} - the estimated relative standard error (coefficient of variation), \cr
      \code{cv} - the estimated relative standard error (coefficient of variation) in percentage, \cr
      \code{absolute_margin_of_error} - the estimated absolute margin of error for period1 for measures of annual, \cr
      \code{relative_margin_of_error} - the estimated relative margin of error in percentage for measures of annual, \cr
      \code{CI_lower} - the estimated confidence interval lower bound, \cr
      \code{CI_upper} - the estimated confidence interval upper bound, \cr
      \code{confidence_level} - the positive value for confidence interval, \cr 
      \code{significant} - is the the difference significant.
 }
}
\description{
Computes the variance estimation for measures of annual net change or annual for single stratified sampling designs.
}
\references{
Guillaume OSIER, Virginie RAYMOND, (2015), Development of methodology for the estimate of variance of annual net changes for LFS-based indicators. Deliverable 1 - Short document with derivation of the methodology.
}
\seealso{
\code{\link{vardchanges}},
         \code{\link{vardannual}}
}
\keyword{vardannual}
