% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/related_rates_grad.R
\name{related_rates_grad}
\alias{related_rates_grad}
\title{Related rates via the gradient (implicit constraint)}
\usage{
related_rates_grad(g, x, known_rates, solve_for, var_names = NULL, h = 1e-06)
}
\arguments{
\item{g}{Function. A scalar function g(x1, x2, ..., xk) defining the implicit
constraint g = 0. It must accept k numeric arguments and return a numeric
scalar.}

\item{x}{Numeric vector of length k. Point where rates are evaluated.
This point should satisfy g(x) = 0 (approximately).}

\item{known_rates}{Numeric vector of known rates. It can be:
(1) a named numeric vector with names matching var_names (e.g. "x","y"),
(2) a named numeric vector with names matching paste0("d", var_names)
(e.g. "dx","dy"), or
(3) an unnamed numeric vector of length k with NA for the unknown component.}

\item{solve_for}{Integer or character. Which rate to solve for. If integer,
it is the position in var_names (1..k). If character, it may be either a
variable name (e.g. "y") or a rate name (e.g. "dy").}

\item{var_names}{Character vector of length k. Variable names. If NULL,
defaults to c("x1","x2",...,"xk").}

\item{h}{Numeric scalar. Step size for numerical partial derivatives.}
}
\value{
A list with components:
\describe{
\item{rate}{Numeric scalar. The solved rate (the requested component of x'(t)).}
\item{rates}{Named numeric vector length k. Full rate vector x'(t). Names are
paste0("d", var_names).}
\item{grad}{Numeric vector length k. Gradient of g at x.}
\item{dot}{Numeric scalar. Dot product grad . rates (should be near 0).}
\item{gx}{Numeric scalar. g(x) value (should be near 0 if x is on the constraint).}
}
}
\description{
Computes related rates for an implicit constraint using the gradient.
Let
\deqn{
  g(\mathbf{x}) = 0,\quad \mathbf{x}=\mathbf{x}(t)\in\mathbb{R}^k.
}
Differentiating with respect to time yields
\deqn{
  \nabla g(\mathbf{x}(t))\cdot \mathbf{x}'(t) = 0.
}
If all components of \eqn{\mathbf{x}'(t)} are known except one, the missing
rate is determined by this orthogonality condition (velocity tangent to the
level set).
}
\examples{
# Ladder (implicit circle): x^2 + y^2 = L^2
# Suppose L = 5, at the instant (x,y) = (4,3) and dx/dt = -1.
# Then dy/dt = -(x/y) dx/dt = (4/3).
g <- function(x, y) x^2 + y^2 - 25

out <- related_rates_grad(
  g = g,
  x = c(4, 3),
  known_rates = c(dx = -1, dy = NA),
  solve_for = "dy",
  var_names = c("x", "y")
)
out$rate
out$rates

}
