% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_functions.R
\name{simulate_functions}
\alias{simulate_functions}
\title{Simulate example functional data}
\usage{
simulate_functions(M, N, seed)
}
\arguments{
\item{M}{Number of functions}

\item{N}{Number of samples per function}

\item{seed}{Seed for reproducibility}
}
\value{
Data frame with the following columns (where f is the function):
\itemize{
  \item t: "time" associated with sample from function where t in [0,1]
  \item y: f(t) for the particular observation
  \item x1: covariate 1 for function $f$ (constant across time)
  \item x2: covariate 2 for function $f$ (constant across time)
  \item x3: covariate 3 for function $f$ (constant across time)
}
}
\description{
Function for simulating a set of functional data based on a deterministic function
    with covariates that affect the shape of the functions
}
\details{
The functions are generated using the following equation:

f(t) = (x_1*exp(-((t-0.3)^2)/0.005)) + (x_2(-((t-(0.7+x_3))^2/0.005)))

where the covariates are generated as follows:

\itemize{
  \item x_1 generated from Unif(0.1,1)
  \item x_2 generated from Unif(0.1,0.5)
  \item x_3 generated from Unif(-0.1,0.1)
}
}
\examples{
# Simulate data
sim_data = simulate_functions(M = 100, N = 75, seed = 20211130)
}
