% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dumbbell_plot.R
\name{dumbbell_plot}
\alias{dumbbell_plot}
\title{dumbbell_plot}
\usage{
dumbbell_plot(
  data,
  ordinalAccessor,
  valueAccessor,
  seriesAccessor,
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{data}{required to be a valid, R data frame. Data used to create chart, an array of objects which includes keys that map to chart accessors.}

\item{ordinalAccessor}{String. Key used to determine dumbbell's categorical property. (similar to x in ggplot)}

\item{valueAccessor}{String. Key used to determine dumbbell's numeric property. (similar to y in ggplot)}

\item{seriesAccessor}{String. Key used to determine dumbbell's series.}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/dumbbell-plot#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/dumbbell-plot}{@visa/dumbbell-plot}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/dumbbell-plot}{@visa/dumbbell-plot}.}
}
\value{
a visaChart htmlwidget object for plotting a dumbbell plot
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/dumbbell-plot}{@visa/dumbbell-plot} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of dumbbell-plot in action:

\if{html}{\figure{dumbbell-plot-1.png}{options: width=400 alt="example dumbbell plot"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/dumbbell-plot}{@visa/dumbbell-plot}.
}
\examples{
library(dplyr)
data.frame(UCBAdmissions) \%>\%
  filter(Admit == "Rejected") \%>\%
  dumbbell_plot("Dept","Freq","Gender")
}
