% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_page.R
\name{update_page}
\alias{update_page}
\title{Update a Page in Canvas LMS}
\usage{
update_page(canvas, course_id, page_id, page_params)
}
\arguments{
\item{canvas}{A list containing the 'api_key' and 'base_url' for authentication.}

\item{course_id}{The ID of the course in which to create the page.}

\item{page_id}{The ID of the page.}

\item{page_params}{A named list of page parameters to update. This list can include:
\describe{
\item{title}{(string) The title for the updated page.}
\item{body}{(string) The content for the updated page.}
\item{published}{(boolean) Whether the page is published (\code{TRUE}) or draft state (\code{FALSE}).}
\item{published_at}{(DateTime) Schedule a future date/time to publish the page.}
}}
}
\value{
A confirmation message that the page has been updated.
}
\description{
Updates an existing page in a specific course using the Canvas LMS API.
}
