% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/km_wlr_calculations_helpers.R
\name{wlr_dhat_estimates}
\alias{wlr_dhat_estimates}
\title{Weighted Log-Rank and Difference Estimate at a Specified Time}
\usage{
wlr_dhat_estimates(
  dfcounting,
  scheme = "fh",
  scheme_params = list(rho = 0, gamma = 0),
  tzero = NULL
)
}
\arguments{
\item{dfcounting}{List output from \code{df_counting} containing risk sets, event counts, and survival estimates.}

\item{scheme}{Character string specifying weighting scheme. One of:
"fh" (Fleming-Harrington), "schemper", "XO", "MB", "custom_time", or "custom_code".}

\item{scheme_params}{Named list with numeric weighting parameters \code{rho}
and \code{gamma} (used for "fh" and "custom_code" schemes).}

\item{tzero}{Time point at which to evaluate the difference in survival (default: 24).}
}
\value{
A list with elements:
\item{lr}{Weighted log-rank test statistic.}
\item{sig2_lr}{Variance of the log-rank statistic.}
\item{dhat}{Difference in survival at \code{tzero}.}
\item{cov_wlr_dhat}{Covariance between log-rank and difference at \code{tzero}.}
\item{sig2_dhat}{Variance of the difference at \code{tzero}.}
\item{cor_wlr_dhat}{Correlation between log-rank and difference at \code{tzero}.}
}
\description{
Computes the weighted log-rank statistic, its variance, the difference in survival at a specified time (\code{tzero}),
the variance of the difference, their covariance, and correlation, using flexible time-dependent weights.
The weighting scheme is selected via the \code{scheme} argument and is calculated using \code{wt.rg.S}.
}
\details{
The weighting scheme is selected via the \code{scheme} argument and calculated using \code{wt.rg.S}.
Supports standard Fleming-Harrington, Schemper, XO (Xu & O'Quigley), MB (Maggir-Burman), custom time-based, and custom code weights.
}
