% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isometric.R
\name{symmetric}
\alias{symmetric}
\title{Enforce Symmetry}
\usage{
symmetric(expand = c(top = FALSE, bottom = FALSE))
}
\arguments{
\item{expand}{amount of scale expansion to allow, e.g. 0.05 (default 0 for best fidelity)}
}
\value{
ggplot_symmetric
}
\description{
Enforces symmetric plot design: y axis includes opposites of the range of the data.
}
\examples{
library(magrittr)
library(ggplot2)
data.frame(x = 1:10, y = c(-2, 5, 0, -1, 4, 0, 1, -3, 3, 0)) \%>\%
ggplot(aes(x, y)) + geom_point() + symmetric()

}
\seealso{
ggplot_add.ggplot_symmetric

Other isometric: 
\code{\link{ggplot_add.ggplot_isometric}()},
\code{\link{ggplot_add.ggplot_symmetric}()},
\code{\link{isometric}()}
}
\concept{isometric}
\keyword{internal}
