.\" Automatically generated by Pandoc 2.7.2
.\"
.TH "sane-hp5590" "5" "13 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.hy
.SH NAME
.PP
sane-hp5590 - SANE backend for Hewlett-Packard
4500C/4570C/5500C/5550C/5590/7650 Workgroup/Document scanners
.SH DESCRIPTION
.PP
The
.B sane-hp5590
library implements a SANE (Scanner Access Now Easy) backend that provides access
to the following Hewlett-Packard Workgroup/Document scanners:
.IP \[bu] 2
ScanJet 4500C
.IP \[bu] 2
ScanJet 4570C
.IP \[bu] 2
ScanJet 5500C
.IP \[bu] 2
ScanJet 5550C
.IP \[bu] 2
ScanJet 5590
.IP \[bu] 2
ScanJet 7650
.PP
If you own a scanner other than the ones listed above that works with
this backend, please let us know this by sending the scanner\[cq]s exact
model name and the USB vendor and device ids (e.g.\ from
.IR /sys/bus/usb/devices ,
.BR sane-find-scanner (1)
or syslog) to us.
Even if the scanner\[cq]s name is only slightly different from the
models mentioned above, please let us know.
.SH OPTIONS
.PP
The options the backend supports can either be selected through command
line options to programs like
.BR scanimage (1)
or through GUI elements in
.BR xscanimage (1)
or
.BR xsane (1).
Valid command line options and their syntax can be listed by using:
.IP
.nf
\f[C]
scanimage --help -d hp5590:interface:device
\f[R]
.fi
.PP
where \f[I]interface\f[R] and \f[I]device\f[R] specify the device in
question, as in the configuration file.
Add
.B --all-options
to also list the hardware read-out options.
The
.B \-d
parameter and its argument can be omitted to obtain information
on the first scanner identified.
.PP
Use the command:
.IP
.nf
\f[C]
scanimage -L
\f[R]
.fi
.PP
to list all devices recognized by your SANE installation.
.SH DEVICE SPECIFIC OPTIONS
.TP
.B -l \f[I]n\f[R]
Top-left X position of scan area in \f[B]mm\f[R].
Allowed range: 0 ..
215.889.
.TP
.B -t \f[I]n\f[R]
Top-left Y position of scan area in \f[B]mm\f[R].
Allowed range: 0 ..
297.699.
.TP
.B -x \f[I]n\f[R]
X width of scan-area in \f[B]mm\f[R].
Allowed range: 0 ..
215.889.
.TP
.B -y \f[I]n\f[R]
Y height of scan-area in \f[B]mm\f[R].
Allowed range: 0 ..
297.699.
.PP
By default, the maximum size will be scanned.
.TP
.B --mode \f[I]mode\f[R]
Select color mode.
\f[I]mode\f[R] must be one of: \[lq]Color\[rq], \[lq]Color (48
bits)\[rq], \[lq]Gray\[rq], \[lq]Lineart\[rq].
.RS
.IP \[bu] 2
\[lq]Color\[rq] - Scanning is done with 3 * 8 bit RGB color values per
pixel.
.IP \[bu] 2
\[lq]Color (48 bits)\[rq] - Scanning is done with 3 * 16 bit RGB color
values per pixel.
.IP \[bu] 2
\[lq]Gray\[rq] - Scanning is done with 1 * 8 bit gray value per pixel.
.IP \[bu] 2
\[lq]Lineart\[rq] - Scanning is done with 1 bit black and white value
per pixel.
.RE
.TP
.B --source \f[I]source\f[R]
Select the source for scanning.
\f[I]source\f[R] must be one of: \[lq]Flatbed\[rq], \[lq]ADF\[rq],
\[lq]ADF Duplex\[rq], \[lq]TMA Slides\[rq], \[lq]TMA Negatives\[rq].
.RS
.IP \[bu] 2
\[lq]Flatbed\[rq] - Scan document on the flat document glass.
.IP \[bu] 2
\[lq]ADF\[rq] - Scan frontsides of documents with automatic document
feeder.
.IP \[bu] 2
\[lq]ADF Duplex\[rq] - Scan front- and backsides of documents with
automatic document feeder.
Note, the backside images must be rotated in a separate post process
step.
.IP \[bu] 2
\[lq]TMA Slides\[rq] - Slide scanning with transparent media adapter.
(Not fully supported by hp5590 backend).
.IP \[bu] 2
\[lq]TMA Negatives\[rq] - Negative film scanning with transparent media
adapter.
(Not fully supported by hp5590 backend).
.RE
.TP
.B --resolution \f[I]res\f[R]
Set the resolution of the scanned image in \f[B]dpi\f[R].
\f[I]res\f[R] must be one of: 100, 200, 300, 600, 1200, 2400.
.PP
Default settings: Lineart, Flatbed, 100dpi.
.TP
.B --extend-lamp-timeout[=yes|no]
Extend lamp timeout period.
no = 15 minutes, yes = 1 hour.
(Default: no)
.TP
.B --wait-for-button[=yes|no]
Wait for button press before scanning starts.
(Default: no)
.TP
.B --preview[=yes|no]
Request a preview-quality scan.
(Default: no)
.TP
.B --hide-eop-pixel[=yes|no]
Hide end-of-page indicator pixels and overwrite with color of next
neighbor pixels.
(Default: yes)
.br
The scanner uses the last pixel in every scan line for storing the
end-of-page status.
This is needed to detect the end of the document sheet when the
automatic document feeder (ADF) is used.
Unfortunately the end-of-page pixels are also generated in flatbed
scans.
It is recommended to hide these pixels.
.TP
.B --trailing-lines-mode \f[I]mode\f[R]
Filling mode of trailing lines after end of page when automatic document
feeder (ADF) is used.
\f[I]mode\f[R] must be one of: \[lq]last\[rq], \[lq]raw\[rq],
\[lq]raster\[rq], \[lq]white\[rq], \[lq]black\[rq], \[lq]color\[rq].
(Default: \[lq]last\[rq])
.RS
.IP \[bu] 2
\[lq]last\[rq] = repeat the last scan line (recommended),
.IP \[bu] 2
\[lq]raw\[rq] = read raw scan data (not recommended),
.IP \[bu] 2
\[lq]raster\[rq] = generate black and white pixel pattern,
.IP \[bu] 2
\[lq]white\[rq] = white pixels,
.IP \[bu] 2
\[lq]black\[rq] = black pixels,
.IP \[bu] 2
\[lq]color\[rq] = RGB or gray colored pixels (see next option).
.RE
.TP
.B --trailing-lines-color \f[I]n\f[R]
Set color value for filling trailing scan lines in trailing lines mode
\[lq]color\[rq] (see previous option).
(Default color: violet)
.br
The RGB color value must be specified and calculated as 65536 * r + 256
* g + b, with r, g, b being values in the range of 0 ..
255.
.SH READ OUT OPTIONS
.PP
The following options allow reading out the button state, counter value,
color setting, and the state of document in ADF.
This can be used to programmatically control corresponding scanner
options like switching between \f[I]flatbed\f[R] and \f[I]ADF\f[R] mode,
or triggering post processing tasks after scanning.
.TP
.B --button-pressed
Get the id of the last button pressed.
Id is one of \[lq]none\[rq], \[lq]power\[rq], \[lq]scan\[rq],
\[lq]collect\[rq], \[lq]file\[rq], \[lq]email\[rq], \[lq]copy\[rq],
\[lq]up\[rq], \[lq]down\[rq], \[lq]mode\[rq], \[lq]cancel\[rq].
.br
The scanner stores the id of the last button pressed until it is read.
After read out, the state is reset and subsequent readings will return
\[lq]none\[rq].

.TP
.B --color-led
Get the state of the color LED indicators.
The state is either \[lq]color\[rq] or \[lq]black_white\[rq].

.TP
.B --counter-value
Get the counter value as shown on LCD.
The value is in the range of 1 ..
99.

.TP
.B --doc-in-adf
Get the state of the document-available indicator of the automatic
document feeder (ADF).
The state is either \[lq]yes\[rq] or \[lq]no\[rq].

.SH HINTS FOR USERS OF SCANBD
.PP
.BR scanbd (8)
is a scanner button daemon, which can read scanner
buttons and trigger scan actions.
.PP
Do not use the old
.BR scanbuttond (8)
interface with hp5590.
It is outdated and shall not be used any more.
The regular interface of
.BR scanbd (8)
is fully supported by the current version
of the \f[I]hp5590\f[R] backend.
.PP
This example shows a minimum configuration file and the corresponding
script file for
.BR scanbd (8)
to be included in
.IR scanbd.conf .
.IP \[bu] 2
.I hp5590.conf
.IP
.nf
\f[C]
device hp5590 {
    # Device matching
    filter = \[dq]\[ha]hp5590.*\[dq]
    desc = \[dq]HP5590 Scanner Family\[dq]

    # Read out counter value and store in environment variable.
    function function_lcd_counter {
        filter = \[dq]\[ha]counter-value.*\[dq]
        desc   = \[dq]hp5590: LCD counter\[dq]
        env    = \[dq]SCANBD_FUNCTION_LCD_COUNTER\[dq]
    }

    # Run scan script when button is pressed.
    action do-scan {
        filter = \[dq]\[ha]button-pressed.*\[dq]
        desc   = \[dq]hp5590: Scan button pressed\[dq]
        script = \[dq]scan_action.script\[dq]
        string-trigger {
            from-value  = \[dq]none\[dq]
            to-value    = \[dq]scan\[dq]
        }
    }
}
\f[R]
.fi
.IP \[bu] 2
\f[B]scan_action.script\f[R]
.IP
.nf
\f[C]
#!/bin/bash
echo device = $SCANBD_DEVICE
echo action = $SCANBD_ACTION
echo counter = $SCANBD_FUNCTION_LCD_COUNTER
scanfile=\[dq]$HOME/tmp/scans/scan-$(date +%s).pnm\[dq]
case $SCANBD_ACTION in
do-scan)
    scanimage -d \[dq]$SCANBD_DEVICE\[dq] > \[dq]$scanfile\[dq]
    ;;
*)
    echo Warning: Unknown scanbd action: \[dq]$SCANBD_ACTION\[dq]
    ;;
esac
\f[R]
.fi
.SH FILES
.TP
.B \f[I]\[at]LIBDIR\[at]/libsane-hp5590.a\f[R]
The static library implementing this backend.
.TP
.B \f[I]\[at]LIBDIR\[at]/libsane-hp5590.so\f[R]
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.PP
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend.
.PP
\f[B]SANE_DEBUG_HP5590\f[R]
.PP
Higher debug levels increase the verbosity of the output:
.IP
.nf
\f[C]
10 - generic processing
20 - verbose backend messages
40 - HP5590 high-level commands
50 - HP5590 low-level (USB-in-USB) commands
\f[R]
.fi
.TP
.B Example:
export SANE_DEBUG_HP5590=50
.SH SEE ALSO
.PP
.BR sane (7),
.BR sane\-usb (5)
.BR scanbd (8),
.BR scanimage (1),
.BR xscanimage (1),
.BR xsane (1)

.SH AUTHORS
Ilia Sotnikov
.RI < hostcc@gmail.com >.
