package org.rcsb.cif.schema.mm;

import org.rcsb.cif.model.*;
import org.rcsb.cif.schema.*;

import javax.annotation.Generated;

/**
 * The binning of the per-reflection signal generated by the
 * software specified by _reflns.pdbx_signal_software_id.
 * If any reflections have a signal &gt;= to the highest threshold
 * specified, an additional bin should be inferred to hold them.
 */
@Generated("org.rcsb.cif.schema.generator.SchemaGenerator")
public class PdbxReflnSignalBinning extends DelegatingCategory {
    public PdbxReflnSignalBinning(Category delegate) {
        super(delegate);
    }

    @Override
    protected Column createDelegate(String columnName, Column column) {
        switch (columnName) {
            case "ordinal":
                return getOrdinal();
            case "upper_threshold":
                return getUpperThreshold();
            default:
                return new DelegatingColumn(column);
        }
    }

    /**
     * The ordinal number of the bin, ordered from lowest signal
     * to highest.
     * @return IntColumn
     */
    public IntColumn getOrdinal() {
        return delegate.getColumn("ordinal", DelegatingIntColumn::new);
    }

    /**
     * The upper (exclusive) threshold of the bin.
     * @return FloatColumn
     */
    public FloatColumn getUpperThreshold() {
        return delegate.getColumn("upper_threshold", DelegatingFloatColumn::new);
    }

}