/*  Copyright (C) 2016 CZ.NIC, z.s.p.o. <knot-dns@labs.nic.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*!
* \file
*
* \brief Error codes and function for getting error message.
*
* \addtogroup libknot
* @{
*/

#pragma once

#include "libknot/errcode.h"

/*!
 * \brief Returns error message for the given error code.
 *
 * \param code Error code.
 *
 * \return String containing the error message.
 */
const char *knot_strerror(int code);

/*!
 * \brief Translates error code from libdnssec into libknot.
 *
 * This is just temporary until everything from libdnssec moved to libknot.
 *
 * \param libdnssec_errcode Error code from libdnssec
 *
 * \return Error code.
 */
int knot_error_from_libdnssec(int libdnssec_errcode);

/*! @} */
