/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


/////////////////////// Qt includes
///////////////////////
#include <QJSEngine>
#include <QJSValue>
#include <QFile>

/////////////////////// Local includes
#include "MsXpS/libXpertMassGui/ScriptingGuiUtils.hpp"
#include "MsXpS/libXpertMassGui/ScriptingWnd.hpp"

namespace MsXpS
{

namespace libXpertMassGui
{

ScriptingGuiUtils::ScriptingGuiUtils(QWidget *scripting_wnd)
  : mp_scriptingWnd(scripting_wnd)
{
}

ScriptingGuiUtils::~ScriptingGuiUtils()
{
}

// This function serves as a js print replacement such that the output of the
// print function goes to the outTextEdit and not to the system shell console.
void
ScriptingGuiUtils::print(const QString &text)
{
  // Get to know the arguments to the jsPrint command, for example:

  // for (var property in ticChromPlot0)
  //{
  // if (ticChromPlot0.hasOwnProperty(property))
  //{
  // jsPrint("property:" + ticChromPlot0[property])
  //}
  //}

  if(mp_scriptingWnd == nullptr)
    qFatalStream() << "Programming error. The pointer cannot be nullptr.";

  static_cast<ScriptingWnd *>(mp_scriptingWnd)->logOutTextEdit(text + "\n");
}

// This function serves as a js print replacement such that the output of the
// print function goes to the provided file nameand not to the system shell
// console.
void
ScriptingGuiUtils::printToFile(const QString &text, const QString &file_name)
{

  QFile file(file_name);
  if(!file.open(QIODevice::WriteOnly | QIODevice::Append))
    {
      static_cast<ScriptingWnd *>(mp_scriptingWnd)
        ->logOutTextEdit(QString("Failed to open file %1.\n").arg(file_name));
    }

  QTextStream stream(&file);
  stream << text;
  stream << "\n";
  stream.flush();
  file.close();
}

void
ScriptingGuiUtils::msleep(int milliseconds) const
{
  QThread::msleep(milliseconds);
}

void
ScriptingGuiUtils::sleep(int seconds) const
{
  QThread::sleep(seconds);
}

} // namespace libXpertMassGui

} // namespace MsXpS
