/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.search.test;

import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.dsm.search.Search;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.NSProperty;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class PerfSearchTest {
    private PerfSearchTest(String[] args) {
        QueryPredicate qp;
        int i;
        if (args.length < 3) {
            System.err.println("Usage: PerfSearchTest url username password [-cas casStr [casStr]] [-name nameStr [nameStr]] [-formula formulaStr [forumulaStr]] [-creator creatorStr [creatorStr]] [-chemprop chempropStr [chempropStr]] [-key keyStr [keyStr]] [-retprops n]");
            System.exit(-1);
        }
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String mHoststr = args[0];
        String username = args[1];
        String passwd = args[2];
        String[] casstr = null;
        String[] namestr = null;
        String[] formulastr = null;
        String[] creatorstr = null;
        String[] chempropstr = null;
        String[] keystr = null;
        int retpropCnt = -1;
        String[] tempstr = new String[]{};
        for (i = 3; i < args.length; ++i) {
            System.out.println("arg " + i + ": " + args[i]);
        }
        System.out.println("\n");
        int j = i = 3;
        int predCnt = 0;
        Vector<String> params = new Vector<String>();
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                j = i++;
                while (i < args.length && !args[i].startsWith("-")) {
                    params.add(args[i]);
                    ++i;
                }
            }
            if (args[j].equalsIgnoreCase("-cas")) {
                predCnt += params.size();
                casstr = params.toArray(tempstr);
            } else if (args[j].equalsIgnoreCase("-name")) {
                predCnt += params.size();
                namestr = params.toArray(tempstr);
            } else if (args[j].equalsIgnoreCase("-formula")) {
                predCnt += params.size();
                formulastr = params.toArray(tempstr);
            } else if (args[j].equalsIgnoreCase("-creator")) {
                predCnt += params.size();
                creatorstr = params.toArray(tempstr);
            } else if (args[j].equalsIgnoreCase("-chemprop")) {
                predCnt += params.size();
                chempropstr = params.toArray(tempstr);
            } else if (args[j].equalsIgnoreCase("-key")) {
                predCnt += params.size();
                keystr = params.toArray(tempstr);
            } else if (args[j].equalsIgnoreCase("-retprops")) {
                retpropCnt = Integer.parseInt((String)params.get(0));
            }
            params.clear();
        }
        Hashtable<NSProperty, QueryPredicate> query = new Hashtable<NSProperty, QueryPredicate>();
        if (casstr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("speciescas"), casstr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("speciescas"), qp);
        }
        if (namestr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("speciesname"), namestr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("speciesname"), qp);
        }
        if (formulastr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("speciesformula"), formulastr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("speciesformula"), qp);
        }
        if (creatorstr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("creator"), creatorstr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("creator"), qp);
        }
        if (chempropstr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("chemicalproperty"), chempropstr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("chemicalproperty"), qp);
        }
        if (keystr != null) {
            qp = new QueryPredicate(CMCSProperties.getPropertyAsNSProperty("keyword"), keystr, "contains", false);
            query.put(CMCSProperties.getPropertyAsNSProperty("keyword"), qp);
        }
        Vector resourceProps = CMCSProperties.getPropertyAsNSPropertyVector("explorerpropertylist");
        resourceProps.remove(CMCSProperties.getPropertyAsNSProperty("resourceurl"));
        resourceProps.add(CMCSProperties.getPropertyAsNSProperty("keyword"));
        resourceProps.add(CMCSProperties.getPropertyAsNSProperty("speciescas"));
        resourceProps.add(CMCSProperties.getPropertyAsNSProperty("speciesname"));
        resourceProps.add(CMCSProperties.getPropertyAsNSProperty("speciesformula"));
        resourceProps.add(CMCSProperties.getPropertyAsNSProperty("chemicalproperty"));
        HashSet returnProperties = new HashSet();
        for (int idx = 0; idx < retpropCnt && idx < resourceProps.size(); ++idx) {
            returnProperties.add(resourceProps.get(idx));
        }
        System.out.println("Using " + query.size() + " query terms with " + predCnt + " predicates");
        System.out.println("Query Terms: " + query.toString());
        System.out.println("\n");
        System.out.println("Properties to return: " + returnProperties.toString());
        System.out.println("\n");
        try {
            Search srch = new Search();
            long start = System.currentTimeMillis();
            Vector results = srch.run(mHoststr, username, passwd, returnProperties, query, Integer.MAX_VALUE);
            long end = System.currentTimeMillis();
            System.out.println("Got " + results.size() + " matches in " + (end - start) + " ms\n");
        }
        catch (Exception ex) {
            System.out.println("errmsg: " + ex.toString());
        }
    }

    public static void main(String[] args) {
        PerfSearchTest pst = new PerfSearchTest(args);
    }
}

