'''OpenGL extension ARB.internalformat_query

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.internalformat_query to provide a more 
Python-friendly API

Overview (from the spec)
	
	OpenGL 4.1 has a number of queries to indicate the maximum number of
	samples available for different formats. These give a coarse-grained
	query mechanism e.g. an implementation can expose different sample
	counts for integer and floating-point formats, but not for different
	floating-point formats. There is also no convenient way for the user
	to determine the granularity of sample counts available, only the
	maximum.
	
	This extension adds a query mechanism that allows the user to
	determine which sample counts are available for a specific internal
	format.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/internalformat_query.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.internalformat_query import *
from OpenGL.raw.GL.ARB.internalformat_query import _EXTENSION_NAME

def glInitInternalformatQueryARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glGetInternalformativ=wrapper.wrapper(glGetInternalformativ).setOutput(
    'params',size=lambda x:(x,),pnameArg='count',orPassIn=True
)
### END AUTOGENERATED SECTION