# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterServerVulnerabilityAssessmentsSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_server_vulnerability_assessments_settings_list_by_subscription(self, resource_group):
        response = self.client.server_vulnerability_assessments_settings.list_by_subscription(
            api_version="2023-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_server_vulnerability_assessments_settings_get(self, resource_group):
        response = await self.client.server_vulnerability_assessments_settings.get(
            setting_kind="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_server_vulnerability_assessments_settings_create_or_update(self, resource_group):
        response = await self.client.server_vulnerability_assessments_settings.create_or_update(
            setting_kind="str",
            server_vulnerability_assessments_setting={
                "kind": "AzureServersSetting",
                "id": "str",
                "name": "str",
                "selectedProvider": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_server_vulnerability_assessments_settings_delete(self, resource_group):
        response = await self.client.server_vulnerability_assessments_settings.delete(
            setting_kind="str",
            api_version="2023-05-01",
        )

        # please add some check logic here by yourself
        # ...
