#' @title insight: A Unified Interface to Access Information from Model Objects in R.
#'
#' @description
#'
#' When fitting any statistical model, there are many useful pieces of information
#' that are simultaneously calculated and stored beyond coefficient estimates
#' and general model fit statistics. Although there exist some generic functions
#' to obtain model information and data, many package-specific modelling functions
#' do not provide such methods to allow users to access such valuable information.
#'
#' **insight** is an R-package that fills this important gap by providing a
#' suite of functions to support almost any model (see a list of the many models
#' supported below in the **List of Supported Packages and Models** section).
#' The goal of **insight**, then, is to provide tools to provide *easy*,
#' *intuitive*, and *consistent* access to information contained in model
#' objects. These tools aid applied research in virtually any field who fit,
#' diagnose, and present statistical models by streamlining access to every
#' aspect of many model objects via consistent syntax and output.
#'
#' References: Lüdecke et al. (2019) \doi{10.21105/joss.01412}.
#'
#' @docType package
#' @aliases insight insight-package
#' @name insight-package
#' @keywords internal
"_PACKAGE"
