## OVERVIEW

This directory contains the CMakeLists.txt for automatically generating
the ASCII code object file, "opencl_blit_objects.cpp", which contains the
blobs of the code object of the Image BLIT kernels for the devices supported
on ROCm.  The blobs are loaded by the image library and required to update
whenever a new device is introduced.


## ADD NEW DEVICE

To add a new supported device, the following steps are required:

  1. Declare an extern variable of the device XXX, by adding the line of
     "extern uint32_t ocl_blit_object_gfxNNN[];" in "blit_kernel.cpp".
  2. Update the BlitKernel::GetPatchedBlitObject() function to support the
     device by assigning "blit_code_object" to "ocl_blit_object_gfxNNN[]".
  3. Add the target to the TARGET_DEVICES list in CMakeLists.txt. Specify using
     the target ID syntax which is the target GFX IP name, optionally followed
     by the settings for the target features such as XNACK and SRAMECC. If
     omitted, a target feature defaults to producing code that will execute on
     any setting. For example, "gfx908" for code that will run on any setting,
     or "gfx908:sramecc+:xnack-" for code that will only run if SRAMECC is
     enabled and XNACK is disabled.
  4. Rebuild the image library.


## REQUIREMENT

In order to create the code object file, the bitcodes of the kernels are
generated by the compiler and the following bitcode libraries are required,

   opencl.bc
   ocml.bc
   irif.bc
   oclc_correctly_rounded_sqrt_off.bc
   oclc_daz_opt_on.bc
   oclc_finite_only_off.bc
   oclc_isa_version_<GFXIP>.bc
   oclc_unsafe_math_off.bc

where <GFXIP> is the gfxip number of the GPU. The directory contains the
bitcode libraries is specified in a CMake varaible.

There are several variables are required for CMake to build the code
object file.  All of them have default values, and defined as following:

      OPENCL_DIR - the location of installed OpenCL
                   (Default: /opt/rocm/opencl)
     BITCODE_DIR - the directory contains the bitcode library
                   (Default: /opt/rocm/amdgcn/bitcode)
        LLVM_DIR - the directory contains the clang, llvm-link and llvm-dis
                   executables
                   (Default: ${PROJECT_BUILD_DIR}/../lightning/bin)
  TARGET_DEVICES - list of gpu types for kernel builds (eg. "gfx900;gfx902")
                   (Default: "gfx900;gfx902;gfx904")


## STEPS TO BUILD

  $ make build
  $ cd build
  $ cmake -D${OPENCL_DIR} -D${BITCODE_DIR} -D${LLVM_DIR} -D${TARGET_DEVICES} ..
  $ make opencl_blit_objects.cpp


