## TFSA-2022-053: `CHECK` failure in constant folding

### CVE Number
CVE-2021-41197

### Impact
The Grappler component of TensorFlow is vulnerable to a denial of service via `CHECK`-failure (assertion failure) in [constant folding](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/grappler/optimizers/constant_folding.cc#L963-L1035):

```cc
  for (const auto& output_prop : output_props) {
    const PartialTensorShape output_shape(output_prop.shape());
    // ...
  }
```

The `output_prop` tensor has a shape that is controlled by user input and this can result in triggering one of the `CHECK`s in the `PartialTensorShape` constructor. This is an instance of [TFSA-2021-198](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2021-198.md) (CVE-2021-41197).

### Patches
We have patched the issue in GitHub commit [be7b286d40bc68cb0b56f702186cc4837d508058](https://github.com/tensorflow/tensorflow/commit/be7b286d40bc68cb0b56f702186cc4837d508058).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
